function init()
{
	debug("Initialising widget " + widget.identifier);
	var doneButton = document.getElementById("done");
	createGenericButton(doneButton, "Done", hideBack);
	var setUserButton = document.getElementById("setUser");
	createGenericButton(setUserButton, "Friends", setUser);
	
	addEvent(doneButton, "mouseover", changePointerToHand, false);
	addEvent(setUserButton, "mouseover", changePointerToHand, false);
	
	var versionLabel = document.getElementById("versionLabel");
	versionLabel.innerHTML = "v" + VERSION;
	
	addEvent("front", "mousemove", mousemove, false);
	addEvent("front", "mouseout", mouseexit, false);
	addEvent("flip", "click", showBack, false);
	addEvent("flip", "mouseover", enterflip, false);
	addEvent("flip", "mouseout", exitflip, false);
	addEvent(FRONT_COLOUR_KEY, "change", setFrontColour, false);
	addEvent(VERSION_CHECK_PREFERENCE_FIELD, "click", setVersionCheck, false);

	var frontColour = getFrontColour();
	changeFrontColour(getFrontColour());

	window.setTimeout("refreshTrackList(true)", 1);
	window.setTimeout("setupFriendsList()", 1);
}

widget.onhide = function()
{
	debug("Hiding widget " + widget.identifier);
	hideTime = new Date();
	if (tracksUpdaterTimeout)
	{
		window.clearTimeout(tracksUpdaterTimeout);
	}
}

widget.onshow = function()
{
	debug("Showing widget " + widget.identifier);
	
	if (versionCheckEnabled())
	{
		doVersionCheck();
	}
	else
	{
		Dhtml.hideElement(NEW_VERSION_AVAILABLE_FIELD);
	}
	
	var showTime = new Date();
	if (hideTime)
	{
		var hideTimeMillis = hideTime.getTime();
	}
	else
	{
		var hideTimeMillis = showTime.getTime();
	}
	var timeSinceLastRefresh = showTime.getTime() - hideTimeMillis;
	debug(timeSinceLastRefresh + " millis since last refresh");
	if (timeSinceLastRefresh > TRACKS_REFRESH_TIME)
	{
		debug("Requesting track list from show event");
		window.setTimeout("refreshTrackList();", 1);
	}
	else
	{
		debug("Setting track list refresh to " + (TRACKS_REFRESH_TIME - timeSinceLastRefresh));
		tracksUpdaterTime = window.setTimeout("refreshTrackList()",
							TRACKS_REFRESH_TIME - timeSinceLastRefresh);
	}
}

function setupFriendsList()
{
	friendsList = new SimpleList(FRIENDS_LIST_ID, setTracksUsername);
	refreshFriendsList();
}

function setupBack()
{
	var usernameField = document.getElementById(USERNAME_PREFERENCE_FIELD);
	usernameField.value = getUsername();
	var colour = getFrontColour();
	var colourList = document.getElementById(FRONT_COLOUR_PREFERENCE_FIELD);
	colourList.value = colour;
	var versionCheck = document.getElementById(VERSION_CHECK_PREFERENCE_FIELD);
	versionCheck.checked = versionCheckEnabled();
}